// let font = new FontFace("yourFontName", "url('path/to/font/file.woff')");
// document.fonts.add(font);

var SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
var recognition = undefined;
let initListener,mainListener

Vue.component('main-comment-set',{
  	data() {
	    return {
	      newCategoryName: '',
	      showAddCategory:false,
	      tooltipContents:'',
	      hasFailedMessage:false,
	      showImport:false,
	      isInvalidFile:false,
	      fromWrongSet:false,
	      connectionLost:false,
	      cantContactBackground:false,
	      showSwitchSet:false,
	      loadingSet:false,
	      cannotSwitch:false
	    }
	},
	computed:{
		categories: function () {
	      return this.$store.state.categories
	    }
	},
	created() {
	    EventBus.$on('popup-event', (data) => {
	      if (this.$vnode.key!==data.id)this.closePopup()
	    })
	    EventBus.$on('tooltip-triggered', (data) => {
			this.$refs.tooltip.innerHTML=data.comment
			this.$refs.tooltip.style.display="initial"
			if (data.aboveButton) this.$refs.tooltip.style.top=
				data.y-this.$refs.tooltip.getBoundingClientRect().height-30+'px'
			else this.$refs.tooltip.style.top=data.y+'px'
			this.$refs.tooltip.style.left=data.x+'px'
	    })
	    EventBus.$on('close-tooltip', () => {
			this.$refs.tooltip.style.display="none"
	    })
	    setInterval(()=>{
	    	console.log(currentCommentSet)
	    	try{
				chrome.runtime.sendMessage({data: "checkIfIsOn",currentCommentSet}, response => this.toggleExtension(response.value))
			}catch(e){
				this.cantContactBackground=true
			}
			// toggleExtension(true)
		},1000)
		mainListener = chrome.runtime.onMessage.addListener((message, sender, sendResponse)=> {
			if (message.data=='addAVComment'){
				console.log(message)
				if (message.postType=="immediate"){
					if(document.querySelector('#insertCommentButton')
						.getAttribute('aria-disabled')=="true"){
						console.log('failed')
						this.failedMessage=message.contents;
						this.hasFailedMessage=true;
					}
					else addCommentToDoc(message.contents)
				}else{
					this.$store.commit('addComment',{
						categoryId:decodeURI(message.categoryId),
						contents:message.contents,
						abbreviation:message.abbreviation,
						type:message.recordingType
					})
				}
			}
			if(message.data=="updateComments"){
				this.$store.commit('replaceAll',{
		    		newState:message.jsonData
				})
			}
			if(message.data=='changeCommentSet'){
				this.loadingSet=false;
				EventBus.$emit('popup-event',{id:null});
				console.log('changeCommentSet',message.jsonData)
				currentCommentSet=message.currentCommentSet
				this.$store.commit('replaceAll',{
		    		newState:message.jsonData
				})				
			}
			if(message.data=='noCommentSetData'){
				console.log('noCommentSetData','response',commentSets[currentCommentSet])
				sendResponse({jsonData:commentSets[currentCommentSet]})
			}
			if(message.data=="connectionLost")this.connectionLost=true
			if(message.data=="reconnected")this.connectionLost=false

			if(message.data=="reconnecting"){
				console.log('reconnecting')
				this.cannotSwitch=true
				this.showSwitchSet=false
			}
			if(message.data=="notReconnecting"){
			console.log('notReconnecting')
				this.cannotSwitch=false
			}
		})
	},
	template:
	`<div id="drag-root" ref="mainRoot">
		<div class="myTooltip" ref='tooltip'></div>
		<div v-if="connectionLost && !cannotSwitch" class="editingStuff warningDialogue">
			<a href="#" @click='openTroubleShooting'>Warning: Not Synced With Google Drive</a>
		</div>
		<div v-if="cannotSwitch" class="editingStuff warningDialogue">
			Reconnecting...
		</div>
		<div v-if="hasFailedMessage" class="editingStuff warningDialogue">
			Your comment failed to post because no text was selected.
			Please select some text and try again.<br>
			<button class='c-button yellowOrange' @click="retryPost">Post Comment</button>
			<button class='c-button c-button--ghost' @click="cancelPost">Cancel</button>
		</div>
		<div v-if="cantContactBackground" class="editingStuff warningDialogue">
			e-Comments cannot sync data. Please make sure that e-Comments has permission to access Google docs 
			and then reload the page to restore the connection.<br>
			<button class='c-button yellowOrange' @click="reloadPage">Reload Page</button>
		</div>		
		<div id="e-commments-style-root" ref='rootRef'>
			<comment-category 
				v-for="(category,index) in categories"
				:category="category"
				:key="category.id"
			>
			</comment-category>
			<button @click='toggleAddCategory' class="c-button yellowOrange u-small">Add Category</button>
			<button @click="toggleImport" class="c-button yellowOrange u-small">Import</button>
			<button @click="exportAll" class="c-button yellowOrange u-small">Export All</button>
			<button @click="toggleSwitchSet" class="c-button yellowOrange u-small" 
				v-show="!cannotSwitch" style="margin-left: -1px">Switch Set</button>

			<div class="addCategory editingStuff" v-show="showAddCategory">
				<input v-model="newCategoryName" placeholder="Category Name" >
				<button @click="addCategory" class="c-button yellowOrange u-small editButton">Add</button>
				<button @click="closePopup" class="c-button c-button--ghost u-small editButton">Cancel</button>
			</div>

			<div class="addCategory editingStuff" v-if="showImport">
			    <input type="file" id="jsonImporter" name="jsonImporter" accept=".json">
			    <div class="horizonal-labels">
					<label class="container">Import Category
					  <input type="radio" name="importType" value="category" checked="checked" id="importCategory">
					</label>&nbsp; &nbsp; 
					<label class="container">Import Comment Set
					  <input type="radio"  name="importType" value="category" id="importCommentSet">
					</label>
				</div>
			    <div v-show="isInvalidFile" style="color:red;">File is not valid.</div>
			    <div v-show="fromWrongSet" style="color:red;">This data belongs to a different comment set.</div>
				<button @click="importComments" class="c-button yellowOrange u-small editButton">Import</button>
				<button @click="closePopup" class="c-button c-button--ghost u-small editButton">Cancel</button>
			</div>
			<div class="addCategory editingStuff" v-show="showSwitchSet">
				<h3 style="margin:0; text-align: center;">Select Comment Set:</h3>
			    <div class="horizonal-labels" style="margin:.5rem;">
				    <div>
						<label class="container">Grades 3−6
						  <input type="radio" name="commentSet" value="elementary" checked="checked">
						</label>
						<label class="container">Grades 6−9
						  <input type="radio"  name="commentSet" value="middle">
						</label>
					</div>
					<div>
						<label class="container">Grades 9-12
						  <input type="radio"  name="commentSet" value="high">
						</label> 
						<label class="container">College/Workplace
						  <input type="radio"  name="commentSet" value="college">
						</label>
					</div>
				</div>
				<button @click="switchSet" class="c-button yellowOrange u-small editButton">Switch Comment Set</button>
				<button @click="closePopup" class="c-button c-button--ghost u-small editButton">Cancel</button>
			</div>
			<div v-if="loadingSet" class="editingStuff">
				<h2 style="text-align:center;">Loading Comment Set...</h2>
			</div>
		</div>
	</div>`,
	methods:{
		switchSet(){
			let radios = document.getElementsByName('commentSet');
			for (let i = 0; i < radios.length; i++){
				if (radios[i].checked){
					currentCommentSet=radios[i].value
					chrome.runtime.sendMessage({data: "changeCommentSet",currentCommentSet})
					break;
				}
			}
			this.loadingSet=true;
			this.closePopup()
		},
		toggleSwitchSet(){
			EventBus.$emit('popup-event',{id:this.$vnode.key});
			this.showSwitchSet=true;
			let radios = document.getElementsByName('commentSet');
			for (let i = 0; i < radios.length; i++){
				if (radios[i].value==currentCommentSet)radios[i].checked=true
			 	else radios[i].checked=false
			}
			scrolltoBottom()
		},
		reloadPage(){
			window.location.reload()
		},
		toggleExtension(response) {
		    if (response==true){
		    	this.$refs.mainRoot.style.display="initial"
				forceIntoWindow()
			}
			else this.$refs.mainRoot.style.display="none"
		},
		openTroubleShooting(){
			chrome.runtime.sendMessage({data: "openTroubleshooting"})
		},
		toggleImport(){
			EventBus.$emit('popup-event',{id:this.$vnode.key});
			this.showImport=true
			this.showSwitchSet=false
			this.isInvalidFile=false;
			this.fromWrongSet=false;
			scrolltoBottom()
		},
		importComments(){
			if (document.querySelector('#jsonImporter').files.length==0) return;
			var fr = new FileReader();
			fr.onload = (e)=>{
				try{
				    var result = JSON.parse(e.target.result);
					if(result.setName!=currentCommentSet && result.type!='custom'){
						this.isInvalidFile=true
						this.fromWrongSet=true
						return;
					}
					if (document.querySelector('#importCommentSet').checked==true){
						if (!result.categories || 
							result.categories.length==0) this.isInvalidFile=true;
						else {
							this.$store.commit('importSet',{newState:result})
							this.showImport=false
						}
					}
					else{ //import comment category
						if (!result.name || !result.comments ||
							result.comments.length==0) this.isInvalidFile=true;
						else{
							this.$store.commit('importCategory',result)
							this.showImport=false
						}
					}
				}catch(e){
					this.isInvalidFile=true;
				}
			}
			fr.readAsText(document.querySelector('#jsonImporter').files[0]);
		},
		exportAll(){
			createDownload(this.$store.state,'commentSet')
		},
		retryPost(){
			if(document.querySelector('#insertCommentButton')
				.getAttribute('aria-disabled')=="false"){
				addCommentToDoc(this.failedMessage)
				this.hasFailedMessage=false
			}
		},
		cancelPost(){
			this.hasFailedMessage=false
		},
		toggleAddCategory(){
			this.showImport=false
			this.showSwitchSet=false
			this.showAddCategory=!this.showAddCategory
			if (this.showAddCategory)EventBus.$emit('popup-event',{id:this.$vnode.key});
			scrolltoBottom()
		},
		closePopup(){
			this.showAddCategory=false;
			this.showImport=false
			this.showSwitchSet=false
			this.newCategoryName=''
		},
		addCategory(){
			if (this.newCategoryName!=''){
				this.$store.commit('addCategory',{
					categoryName:this.newCategoryName
				})
				this.newCategoryName='';
				this.toggleAddCategory();
			}
			else{
				console.log('need text')
			}
		}
	}

})

Vue.component('comment-category',{
	data(){
		return{
			showEditingStuff:false,
			contents:'',
			abbreviation:'',
			showCategoryEdit:false,
			showDeleteWarning:false,
			showRestoreWarning:false,
			dynamicCategoryName:this.category.name,
			commentTextareaRef:this.category.id+'commentTextarea',
		}//$vnode.key
	},
	created() {
	    EventBus.$on('popup-event', (data) => {
	      if (this.$vnode.key!==data.id)this.closePopups()
	    })
	},
	mounted() {
	  this.$nextTick(function () {
	    // Code that will run only after the entire view has been rendered
   	    dragElement(categoryheaders[categoryheaders.length-1]);
	  })
	},
	props:{
		category: Object,
		categoryIndex: Number,
	},
	computed:{
		headerStyle(){
			return this.category.type == 'default' ?
					{backgroundColor: '#101c40',color: 'white'} :
					{backgroundColor:'#10401C',color:'white'}
		}
	},
	template:
	`<div class="commentCategory">
		<p class="commentCategoryHeader"
			:style="headerStyle"
			@contextmenu.prevent="toggleShowCategoryEdit">{{dynamicCategoryName}}
		</p>
		<div class="editingStuff" v-if="showCategoryEdit && category.type=='custom'" ref="a">
			<input v-model="dynamicCategoryName" placeholder="Type New Name" ><br>
			<button @click="updateCategoryName" class="c-button yellowOrange u-small editButton">Save</button>
			<button @click="exportCategory" class="c-button yellowOrange u-small editButton">Export</button>	
			<button @click="cancelEditCategoryName" class="c-button c-button--ghost u-small editButton">Cancel</button>
			<img src="chrome-extension://dccccbckfnndplihkaeiekggmeicbhgj/img/garbage-24px.png" title="delete" alt="Delete" @click="showDeleteWarningPopup" class="editButton delete" />
		</div>

		<div class="editingStuff" v-if="showDeleteWarning && category.type=='custom'" ref="b">
			<p>Are you sure you want to delete this category and all of its comments? This cannot be undone. 
				Please back-up any important contents before deleting.</p>
			<button @click="exportCategory" class="c-button u-small editButton yellowOrange">
				Export Comment Category
			</button>
			<br />
			<button @click="deleteCategory" class="c-button c-button--error u-small editButton">Delete</button>
			<button @click="closePopups" class="c-button c-button--ghost u-small editButton">Cancel</button>
		</div>		
		<div class="editingStuff" v-if="showCategoryEdit && category.type=='default'" ref="c">
			<button @click="showRestoreWarningPopup" class="c-button yellowOrange u-small editButton">
				Restore Default Comments
			</button>
			<button @click="exportCategory" class="c-button yellowOrange u-small editButton">Export</button>	
			<button @click="closePopups" class="c-button c-button--ghost u-small editButton">Cancel</button>
		</div>
		<div class="editingStuff" v-if="showRestoreWarning && category.type=='default'" ref="d">
			<p>Are you sure you want to restore the original comments for this category? 
			Custom comments in this category will be deleted. This cannot be undone. 
				Please back-up any important contents before deleting.</p>
			<button @click="exportCategory" class="c-button u-small editButton yellowOrange">
				Export Comment Category
			</button>
			<br />
			<button @click="restoreDefaults" class="c-button c-button--error u-small editButton">Restore Default</button>
			<button @click="closePopups" class="c-button c-button--ghost u-small editButton">Cancel</button>
		</div>		
		<comment 
			v-for="(comment,index) in category.comments"
			:comment="comment"
			:key="comment.id"
			:categoryId="$vnode.key"
			:isDefault="category.type=='default' && comment.isCustom!=true"
		></comment>
		<div style="display: inline-block;line-height: 23px;margin-left: 3px;">
			<img @click='toggleEdit' class="AVIcon" title="add text comment" alt="text comment"
				src="chrome-extension://dccccbckfnndplihkaeiekggmeicbhgj/img/cross.svg"
				style="height: 16px;margin-bottom: -4px;"
			>
			<img @click="addAVComment('audio')" class="AVIcon" title="add audio comment" alt="audio comment"
				src="chrome-extension://dccccbckfnndplihkaeiekggmeicbhgj/img/microphone.svg"
				style="height: 22px;margin-bottom: -8px;"
			>
			<img @click="addAVComment('video')" class="AVIcon" title="add video comment" alt="video comment"
				src="chrome-extension://dccccbckfnndplihkaeiekggmeicbhgj/img/video.svg"
				style="height: 26px;margin-bottom: -10px;margin-left: -5px;"
			>
		</div>
		<text-editor :categoryId="$vnode.key" :comment="{comment:'',abbreviation:'',type:'text'}" 
			v-if="showEditingStuff"></text-editor>
	</div>`,
	methods:{
		scrollIfNeeded(){
			setTimeout(()=>{
				let ref
				if(this.showCategoryEdit && this.category.type=='custom')ref='a'
				if(this.showDeleteWarning && this.category.type=='custom')ref='b'
				if(this.showCategoryEdit && this.category.type=='default')ref='c'
				if(this.showRestoreWarning && this.category.type=='default')ref='d'
				if (ref) this.$refs[ref].scrollIntoViewIfNeeded()
			},100)
		},
		addAVComment(type){
			chrome.runtime.sendMessage({data: "openAVcomment",type,categoryId:this.$vnode.key})
		},
		// copyContents(){
		// 	let formatted=''
		// 	this.category.comments.forEach(entry=>{
		// 		formatted+=entry.abbreviation+'\n\n'+entry.comment+'\n\n'
		// 	})
		// 	copyToClipboard(formatted)
		// },
		exportCategory(){
			this.closePopups();
			createDownload(this.category,'commentCategory')
		},
		decorateText(decorator){
			let commentRef=this.$refs[this.commentTextareaRef]
			if(commentRef.selectionStart==commentRef.selectionEnd) return;
			//open tag
			let open=this.contents.slice(0, commentRef.selectionStart)
			+decorator+this.contents.slice(commentRef.selectionStart)
			//close tag
			this.contents=open.slice(0, commentRef.selectionEnd+1)
			+decorator+open.slice(commentRef.selectionEnd+1)
		},
		closePopups(){
			this.showEditingStuff=false;
			this.showCategoryEdit=false;
			this.showDeleteWarning=false;
			this.showRestoreWarning=false;
			this.contents='';
			this.abbreviation='';
		},
		cancelEditCategoryName(){
			this.closePopups();
			this.dynamicCategoryName=this.category.name;
		},
		//redundant??
		toggleEdit(){
			this.showEditingStuff=!this.showEditingStuff
			this.showCategoryEdit=false;
			this.showDeleteWarning=false;
			this.showRestoreWarning=false;
			if (this.showEditingStuff)EventBus.$emit('popup-event',{id:this.$vnode.key});
			this.scrollIfNeeded()
		},
		toggleShowCategoryEdit(){
			this.showCategoryEdit=!this.showCategoryEdit
			this.showEditingStuff=false
			this.showDeleteWarning=false;
			this.showRestoreWarning=false;
			if (this.showCategoryEdit)EventBus.$emit('popup-event',{id:this.$vnode.key});
			this.scrollIfNeeded()
		},
		showDeleteWarningPopup(){
			this.closePopups()
			this.showDeleteWarning=true;
			this.scrollIfNeeded()
		},
		showRestoreWarningPopup(){
			this.closePopups()
			this.showRestoreWarning=true;
			this.scrollIfNeeded()
		},
		deleteCategory(){
			this.$store.commit('deleteCategory',{
				categoryId:this.$vnode.key,
			})
		},
		updateCategoryName(){
			this.$store.commit('updateCategoryName',{
				categoryId:this.$vnode.key,
				categoryName:this.dynamicCategoryName
			})
			this.closePopups()
		},
		restoreDefaults(){
			this.$store.commit('restoreDefaults',{
				categoryId:this.$vnode.key,
			})
			this.closePopups()
		}
	}

})

Vue.component('comment',{
	data(){
		return{
			showEditingStuff:false,
			showXForm:false,
			buttonRef:'buttonRef'+this.$vnode.key
		}
	},
	created() {
	    EventBus.$on('popup-event', data => {
	      if (this.$vnode.key!==data.id)this.closePopup()
	    })
	},
	props:{
		categoryId: String,
		comment: Object,
		isDefault: Boolean
	},
	computed:{
		tooltipWithStyling(){
			return cleanUpComment(styleText(this.comment.comment))
		},			
	},
	template:`
		<div class="commentButton" ref="buttonRef">
			<button @click="prepareToAddCommentToDoc" 
				@contextmenu.prevent="toggleEdit" 
				class="c-button u-xsmall lightBlue" 
				@mouseover="showToolTip" 
				@mouseleave="hideToolTip"
			>
				<img class="small-video-icon" v-if="comment.type=='video'" alt="video comment" 
					src="chrome-extension://dccccbckfnndplihkaeiekggmeicbhgj/img/video-white.svg" />
				<img class="small-audio-icon" v-if="comment.type=='audio'" alt="audio comment" 
					src="chrome-extension://dccccbckfnndplihkaeiekggmeicbhgj/img/mic-white.svg" />
				{{comment.abbreviation}} 
			</button> 
			<text-editor :categoryId="categoryId" :commentId="$vnode.key" 
			:comment="comment" v-if="showEditingStuff" :isDefault="isDefault"></text-editor>
			<xForm :comment="comment.comment" v-if="showXForm"></xForm>
		</div>`,
	methods:{
		showToolTip(){
			let clientRect= this.$refs.buttonRef.getClientRects()[0]
			EventBus.$emit('tooltip-triggered',
				{comment:this.tooltipWithStyling,
				 x:clientRect.x, y:clientRect.y,
				 aboveButton:clientRect.y>window.innerHeight/2 ? true : false
				})
		},
		hideToolTip(){
			EventBus.$emit('close-tooltip');
		},
		prepareToAddCommentToDoc(comment,abbreviation){
			//remove ugly underlines
			let cleanedUpComment=cleanUpComment(this.comment.comment)

			if (cleanedUpComment.includes('✖')){
				this.showXForm=true;
				this.showEditingStuff=false;
				EventBus.$emit('popup-event',{id:this.$vnode.key});
			}
			else addCommentToDoc(cleanedUpComment)
		},
		closePopup(){
			this.showEditingStuff=false;
			this.showXForm=false;
		},
		toggleEdit(){
			this.showEditingStuff=true
			this.showXForm=false;
			if (this.showEditingStuff)EventBus.$emit('popup-event',{id:this.$vnode.key});
		},
	}
})

Vue.component('xForm',{
	props:{
		comment:String
	},
	created(){
		let form = cleanUpComment(styleText(this.comment)).split('✖');
		form.forEach((line,i)=>{
			this.rawHtml+=line
			if (i<form.length-1) this.rawHtml+='<br /><input type="text" class="e-comments-output-form" /><br />'
		})
	},
	data(){
		return{
			rawHtml:''
		}
	},
	template:`
	<div class='editingStuff small'>
		<div v-html="rawHtml"></div>
		<button @click="postComment" class="c-button yellowOrange u-small editButton">Post Comment</button>
		<button @click="close" class="c-button c-button--ghost u-small editButton">Cancel</button>
	</div>
	`,
	methods:{
		postComment(){
			let formText = this.comment.split('✖');
			let finalOutput=''
			let inputs = document.getElementsByClassName('e-comments-output-form')
			formText.forEach((line,i)=>{
				finalOutput+=line
				if (i<formText.length-1) finalOutput+=inputs[i].value
			})
			addCommentToDoc(cleanUpComment(finalOutput))
			this.close()
		},
		close(){ EventBus.$emit('popup-event',{id:null}); }
	}
})


Vue.component('text-editor',{
	data(){
		return{
			isBold:false,
			abbreviation:this.comment.abbreviation,
			contents:this.comment.comment,
			type:this.comment.type,
			commentTextareaRef:this.comment.id+'commentTextarea',
			ghostTextareaRef:this.comment.id+'ghostTextareaRef',
			recording:false,
		}
	},
	props:{
		categoryId: String,
		commentId:String,
		comment: Object,
		isDefault:Boolean
	},
	mounted(){
		document.querySelector('#eCommentsTextEditor').scrollIntoViewIfNeeded()
		this.commentRef=this.$refs[this.commentTextareaRef]
	},
	computed:{
		commentWithStyling(){
			return styleText(this.contents,'editor')
		}
	},
	template:`
	<div class="editingStuff" id="eCommentsTextEditor">
		<div class='textDecorationBar'>
			<button title="bold" alt="bold" class="noFocus" v-bind:class="{editButtonSelected:isBold}" 
			style="font-weight:bold;" @click="decorateText('*')">B</button>
			<button title="italic" alt="italic" class="noFocus" style="font-style: italic;" @click="decorateText('_')">I</button>
			<button title="underline" alt="underline" class="noFocus" style="text-decoration: underline;" @click="underlineText">U</button>
			<button title="strike-through" alt="strike-through" class="noFocus" style="text-decoration: line-through;" @click="decorateText('-')">S</button>
			<button title="bullet" alt="bullet" class="noFocus" @click="addsymbol('▪')">▪</button>
			<button title="fill-in-the-blank" alt="fill-in-the-blank" class="noFocus" @click="addsymbol('✖')">✖</button>
			<button title="speech-to-text" alt="speech-to-text" class="noFocus" @click="toggleMic">
				<span v-if="recording">End</span>
				<img v-if="!recording" alt="speech to text" class="textToSpeech"
					src="chrome-extension://dccccbckfnndplihkaeiekggmeicbhgj/img/speech-text.svg" 
				/>
			</button>
		</div>
		<div class="recording" v-show="recording"><span class="blink">🔴</span> Speak Into Microphone...</div>
		<input v-model="abbreviation" 
				placeholder="Abbreviation..." 
				id="textEditorInput"><br>
		<div v-innerHTML="commentWithStyling" class='ghostTextarea' :ref="ghostTextareaRef"></div>
		<textarea 
			class="myTextArea"
			:ref="commentTextareaRef" 
			v-model="contents" 
			placeholder="Comment..."
			@scroll="handleScroll" 
			@mouseup="colorStylingButtons"
		>
		</textarea>
		<br>
		<button @click="postComment" class="c-button yellowOrange u-small editButton">Save</button>
		<button v-if="commentId && isDefault" @click="restoreComment" class="c-button yellowOrange u-small editButton">Restore</button>
		<button @click="cancel" class="c-button c-button--ghost u-small editButton">Cancel</button>
		<img title='delete' src="chrome-extension://dccccbckfnndplihkaeiekggmeicbhgj/img/garbage-24px.png" alt="Delete" @click="deleteComment" class="editButton delete" />
	</div>`,
	methods:{
		underlineText(){
			this.savedscrollTop=this.commentRef.scrollTop
			let selectionEnd=this.commentRef.selectionEnd,selectionStart=this.commentRef.selectionStart
			if (this.contents[selectionEnd-1]==='\n') selectionEnd--
			
			let unstyled=this.contents.slice(selectionStart,selectionEnd),styled=""
			if (unstyled.includes('◌̲'[1])){
				styled=unstyled.split('◌̲'[1]).join('')
				this.contents=this.contents.slice(0,selectionStart)+styled+this.contents.slice(selectionEnd)
				this.refocusTextEditor(selectionEnd-styled.length)
			}else{		
				let c = '◌̲'[1]
				unstyled.split('').forEach(letter=>{
					styled += letter+c
				})
				this.contents=this.contents.slice(0,selectionStart)+styled+this.contents.slice(selectionEnd)
				this.refocusTextEditor(selectionEnd+styled.length/2)
			}
		},
		addsymbol(symbol){
			let selectionEnd=this.commentRef.selectionEnd
			this.savedscrollTop=this.commentRef.scrollTop
			this.contents=this.contents.slice(0,selectionEnd)+symbol+this.contents.slice(selectionEnd)
			this.refocusTextEditor(selectionEnd+1)
		},
		colorStylingButtons(){
			console.log('changeButtonState')
		},
		deleteComment(){
			this.$store.commit('deleteComment',{
				categoryId:this.categoryId,
				commentId:this.commentId,
			})
			EventBus.$emit('popup-event',{id:null});
		},
		postComment(){
			if (this.contents==='' || this.abbreviation==='') return;
			if (!this.commentId){
				this.$store.commit('addComment',{
					categoryId:this.categoryId,
					contents:this.contents,
					abbreviation:this.abbreviation,
					type:this.type
				})
			}
			else{
				this.$store.commit('updateComment',{
					categoryId:this.categoryId,
					commentId:this.commentId,
					contents:this.contents,
					abbreviation:this.abbreviation,
					type:this.type,
					isCustom:this.isCustom
				})
			}
			EventBus.$emit('popup-event',{id:null});
		},
		restoreComment(){
			this.$store.commit('restoreDefaultComment',{
				categoryId:this.categoryId,
				commentId:this.commentId,
			})			
			EventBus.$emit('popup-event',{id:null});
		},
		decorateText(decorator){
			this.savedscrollTop=this.commentRef.scrollTop
			let selectionStart=this.commentRef.selectionStart,selectionEnd=this.commentRef.selectionEnd
			if (this.contents[selectionEnd-1]==='\n') selectionEnd--
			let selectedSlice=this.contents.slice(selectionStart,selectionEnd)
			
			//check if one line or multiline
			let isSingleLine=true
			if (selectedSlice.includes('\n')) isSingleLine=false

			//check if already contains bold
			let hasBold=false
			this.contents.split('').forEach((char,index,arr)=>{
				if (index>=selectionStart-1 && index<=selectionEnd &&
					decorator==char &&
					((arr[index+1]!==' ' &&
					 (index==0 || isSpecialChar(arr[index-1].charCodeAt(0)))
					) 
					||
		        	(arr[index-1]!==' ' &&
		        	 (index==arr.length-1 || isSpecialChar(arr[index+1].charCodeAt(0)))
		        	)
		        ))hasBold=true
			})

			if (isSingleLine && hasBold) this.removeAllDecoration(decorator,selectionStart,selectionEnd)
			else if (isSingleLine && !hasBold) this.decorateSingleLine(decorator,selectionStart,selectionEnd)
			else if (!isSingleLine){
				//find starting and ending lines
				let startLine,endLine,currentPos=0,lineStartPos=0,startlineStart,endlineEnd
				this.contents.split('\n').forEach((line,index,arr)=>{
					line.split('').forEach(char=>{
						if (currentPos==selectionStart){
							startLine=index
							startlineStart=lineStartPos
						}
						if (currentPos==selectionEnd){
							endLine=index
							endlineEnd=lineStartPos+line.length
						}
						currentPos++
					})
					if (currentPos==selectionStart){
						startLine=index
						startlineStart=lineStartPos
					}
					if (currentPos==selectionEnd){
						endLine=index
						endlineEnd=lineStartPos+line.length
					}
					currentPos++
					lineStartPos+=line.length+1
				})

				if (hasBold)this.removeAllDecoration(decorator,startlineStart,endlineEnd)
				else this.decorateMultiLine(decorator,selectionStart,selectionEnd,startLine,endLine)
			}
		},
		decorateMultiLine(decorator,selectionStart,selectionEnd,startLine,endLine){
			let newContents='',difference=0,pos=0
			this.contents.split('\n').forEach((line,index,arr)=>{
				if(index>=startLine && index<=endLine){
					newContents+=decorator+line+decorator
					difference+=2
				}
				else newContents+=line
				if (index<arr.length-1)newContents+='\n'
			})
			this.contents=newContents
			this.refocusTextEditor(selectionEnd+difference)
		},
		removeAllDecoration(decorator,selectionStart,selectionEnd){
			let newContents='',difference=0,sameLine=true
			this.contents.split('').forEach((char,index,arr)=>{
				if (index>=selectionStart-1 && index<=selectionEnd &&
					decorator==char &&
					((arr[index+1]!==' ' &&
					 (index==0 || isSpecialChar(arr[index-1].charCodeAt(0)))
					) 
					||
		        	(arr[index-1]!==' ' &&
		        	 (index==arr.length-1 || isSpecialChar(arr[index+1].charCodeAt(0)))
		        	)
		        )){
					if (index<selectionEnd)difference++
				}
				else newContents+=char
			})
			this.contents=newContents
			this.refocusTextEditor(selectionEnd-difference)
		},
		decorateSingleLine(decorator,selectionStart,selectionEnd){
			// console.log()
			if ((selectionEnd-selectionStart==0 || selectionEnd-selectionStart==1)&& 
			this.contents[selectionStart-1]===decorator &&
			this.contents[selectionStart]===decorator){
				this.contents= this.contents.slice(0, selectionStart-1)+this.contents.slice(selectionStart+1);
				this.refocusTextEditor(selectionStart-1)
			}
			else if(selectionEnd-selectionStart==1 &&
				this.contents[selectionStart]===decorator &&
			this.contents[selectionStart+1]===decorator){
				this.contents= this.contents.slice(0, selectionStart)+this.contents.slice(selectionEnd+1);
				this.refocusTextEditor(selectionEnd-1)
			}
			else{
				if (this.contents[selectionStart-1]==decorator &&
					this.contents[selectionEnd]==decorator){
						this.contents = this.contents.slice(0, selectionStart-1)+
						this.contents.slice(selectionStart,selectionEnd)+
						this.contents.slice(selectionEnd+1)
						this.refocusTextEditor(selectionEnd-1)
						return;
				}
				if (this.contents[selectionStart]==decorator &&
					this.contents[selectionEnd-1]==decorator){
						this.contents = this.contents.slice(0, selectionStart)+
						this.contents.slice(selectionStart+1,selectionEnd-1)+
						this.contents.slice(selectionEnd)
						this.refocusTextEditor(selectionEnd-2)
						return;
				}				

				//open tag
			    let open=this.contents.slice(0, selectionStart)
				+decorator+this.contents.slice(selectionStart)
				//close tag
				this.contents= open.slice(0, selectionEnd+1)+decorator+open.slice(selectionEnd+1);
				this.refocusTextEditor(selectionEnd+1)
			}

		},
		refocusTextEditor(position){
			//note: must use 'this.savedscrollTop=this.commentRef.scrollTop'
			//before modifying textcontent or scroll will be wrong
			setTimeout(()=>{
	        	//if (needToScrollBack) 
	        	this.commentRef.focus()
			    this.commentRef.selectionStart = position
		        this.commentRef.selectionEnd = position
    			this.commentRef.scrollTop=this.savedscrollTop
	        	//this.scrollTo(this.commentRef, position)
		    }, 50);
		},
		cancel(){
			if (this.recording){
				this.recording=false
				this.recognition.stop()
			}
			EventBus.$emit('popup-event',{id:null});
		},
		toggleMic(){
			this.refocusTextEditor(this.$refs[this.commentTextareaRef].selectionStart)
			if (this.recording){
				this.recording=false
				this.recognition.stop()
			}
			else {
				this.commentRef.focus()
				this.commentRef.selectionStart=0
				this.commentRef.selectionEnd=0

				if (!this.recognition) {
					this.recognition= new window.SpeechRecognition();
					this.recognition.continuous = true;
					this.recognition.interimResults = false;
					this.recognition.lang = "en-US";

					this.recognition.onend = (evt)=> {
						//console.log('onend',evt,this.recognition)
					    if (this.recording) this.recognition.start();
					}
					this.recognition.onstart= (evt) => {
						this.recording=true
					}
					this.recognition.error= (error) => {
						console.log(error)
						this.recording=false
					}
					this.recognition.onresult = (event)=> {
						this.savedscrollTop=this.commentRef.scrollTop
						//console.log('onresult')
					    var current = event.resultIndex;
					    var transcript = event.results[current][0].transcript;
					    //console.log(transcript)
					    let selectionStart=this.commentRef.selectionStart
					    let uncapitalized = this.contents.slice(0, this.commentRef.selectionStart) 
					    + transcript + this.contents.slice(this.commentRef.selectionStart);
					    this.contents=capitalizeSentences(uncapitalized)
					    this.refocusTextEditor(selectionStart+transcript.length)
					}
				} 
				this.recognition.start()
			}
		},
		handleScroll(evt, el){
			this.$refs[this.ghostTextareaRef].scrollTop=evt.srcElement.scrollTop
		},
	}
	
})


Vue.directive('innerHTML', {
  update: function (el, binding) {
    el.innerHTML = binding.value
  },
  bind: function (el, binding) {
    el.innerHTML = binding.value
  }
})

const EventBus = new Vue();
let store,app,categoryheaders

function init(){
	store = new Vuex.Store({
	  	state: JSON.parse(JSON.stringify(initialState)),

	    mutations: {
		    addComment(state,payload) {
		    	console.log(state)
		    	let i = state.categories.findIndex((category)=>{
		    		return category.id==payload.categoryId
		    	})
		    	state.categories[i].comments.push({
		    		type:(payload.type?payload.type:'text'),
		    		isCustom:true,
			    	abbreviation:payload.abbreviation,
					comment:payload.contents,
					id:payload.abbreviation+Math.random()
		    	})
		    },
		    deleteComment(state,payload) {
		    	let i = state.categories.findIndex(category=>
		    		category.id==payload.categoryId
		    	)
		    	let j = state.categories[i].comments.findIndex(comment=>
		    		comment.id==payload.commentId
		    	)
			    state.categories[i].comments.splice(j,1)
		    },
		    updateComment(state,payload) {
		    	let i = state.categories.findIndex(category=>
		    		category.id==payload.categoryId
		    	)
		    	let j = state.categories[i].comments.findIndex(comment=>
		    		comment.id==payload.commentId
		    	)
			    state.categories[i].comments.splice(j,1,{
		    		type:(payload.type?payload.type:'text'),
		    		isCustom:payload.isCustom,
			    	abbreviation:payload.abbreviation,
					comment:payload.contents,
					id:payload.commentId
			    })

		    },
		    restoreDefaultComment(state,payload){
		    	let i = state.categories.findIndex(category=>
		    		category.id==payload.categoryId
		    	)
		    	let j = state.categories[i].comments.findIndex(comment=>
		    		comment.id==payload.commentId
		    	)
			    state.categories[i].comments.splice(j,1,{
		    		type:'text',
			    	abbreviation:JSON.parse(JSON.stringify(commentSets[currentCommentSet].categories[i].comments[j].abbreviation)), 
					comment:JSON.parse(JSON.stringify(commentSets[currentCommentSet].categories[i].comments[j].comment)), 
					id:state.categories[i].comments[j].id
			    })		    	
		    },
		    addCategory(state,payload) {
		    	state.categories.push({
		    		name:payload.categoryName,
		    		type:'custom',
		    		id:payload.categoryName+Math.random(),
		    		comments:[]
		    	})
		    },
		    deleteCategory(state,payload) {
		    	let i = state.categories.findIndex(category=>
		    		category.id==payload.categoryId
		    		)
		    	state.categories.splice(i,1)
		    },
		    updateCategoryName(state,payload){
		    	let i = state.categories.findIndex(category=>
		    		category.id==payload.categoryId
		    	)
		    	state.categories.splice(i,1,
		    		{
		    			type:'custom', 
		    			name:payload.categoryName, 
		    			comments:[...state.categories[i].comments],
		    			id:state.categories[i].id,
		    		})
		    },
		    restoreDefaults(state,payload){
		    	let i = state.categories.findIndex(category=>
		    		category.id==payload.categoryId
		    	)
		    	state.categories.splice(i,1,
		    		{
		    			name:JSON.parse(JSON.stringify(commentSets[currentCommentSet].categories[i].name)), 
		    			type:JSON.parse(JSON.stringify(commentSets[currentCommentSet].categories[i].type)), 
		    			comments:[...JSON.parse(JSON.stringify(commentSets[currentCommentSet].categories[i].comments))],
		    			id:state.categories[i].id,
		    		})
	    		// state.categories[i].comments.forEach((comment,j)=>{
	    		// 	if (!state.categories[i].comments[j].id)
	    		// 	state.categories[i].comments[j].id=comment.abbreviation+Math.random()
	    		// })
		    },
		    addKeys(state){
		    	state.categories.forEach((category,i)=>{
		    		if (!state.categories[i].id) state.categories[i].id=category.name+Math.random()
		    		state.categories[i].comments.forEach((comment,j)=>{
		    			if (!state.categories[i].comments[j].id)
		    			state.categories[i].comments[j].id=comment.abbreviation+Math.random()
		    		})
		    	})
		    },
		    replaceAll(state,payload){
		    	Object.assign(state, payload.newState);
		    },
		    importSet(state,payload){
		    	Object.assign(state, payload.newState);
		    },
		    importCategory(state,payload){
		    	let i = state.categories.findIndex(category=>
		    		category.id==payload.id
		    	)
		    	if (payload.type=='custom'){
			    	state.categories.push({
			    		name:payload.name,
			    		type:'custom',
			    		id:payload.id,
			    		comments:payload.comments
			    	})
		    	}else{
		    		//get correct ids
		    		// payload.comments.forEach((payloadComment,commentIndex)=>{
		    		// 	let j = state.categories[i].comments.findIndex(defaultComment=>
		    		// 		payloadComment.id==defaultComment.id
		    		// 	)
		    		// 	if (j>-1)payload.categories[i].comments[commentIndex].id=
		    		// 		state.categories[i].comments[j].id
		    		// 	else payload.categories[i].comments[commentIndex].isCustom=true
		    		// })
			    	state.categories.splice(i,1,{
			    		name:payload.name,
			    		type:'default',
			    		id:state.categories[i].id,
			    		comments:payload.comments
				    })
		    	}
		    }
	    }
	})

	if (document.querySelector('#e-commments-vue-root')){
		console.log('uh oh!')
	}
	const root= document.createElement("div");
	root.id='e-commments-vue-root'
	document.querySelector('body').appendChild(root)

	app = new Vue({
		el:'#e-commments-vue-root',
		//el:'#app',
		store,
		created: function () {
			//store.commit('addKeys')
			store.subscribe((mutation, state) => {
			  if (mutation.type!='replaceAll'){
			  	console.log('mutation:',mutation)
			  	chrome.runtime.sendMessage({data: "postComments",jsonData:state})
			  }
			  if (mutation.type=='replaceAll' || mutation.type=='importSet') {
			  	setTimeout(makeDraggable,100)
			  }
			})
	  	},
		template:`
			<main-comment-set></main-comment-set>
		`,
	})

	makeDraggable()
	setTimeout(forceIntoWindow,1000)
}




let defaultSet='elementary',initialState,isOn=false,alreadyInitialized=false,currentCommentSet
let commentSets={elementary,middle,high,college}
chrome.runtime.sendMessage({data: "newTabOpened"})
console.log("newTabOpened")
console.log(initListener,mainListener)

initListener = chrome.runtime.onMessage.addListener(async function(message, sender, sendResponse){
	if (message.data=='initialData' && !alreadyInitialized){
		console.log('got initial data',message.jsonData)
		alreadyInitialized=true
		currentCommentSet=message.currentCommentSet
		initialState=message.jsonData
		init()
	}
	if (message.data=='noInitialData' && !alreadyInitialized){
		alreadyInitialized=true
		if (!message.currentCommentSet) currentCommentSet = defaultSet
		else currentCommentSet = message.currentCommentSet
		initialState=JSON.parse(JSON.stringify(commentSets[currentCommentSet]))
		sendResponse({'jsonData':initialState,currentCommentSet})
		init()
	}

	///////for testing!
	//uncomment this and comment the above to load whatever is in elementaryComments
	// if ((message.data=='noInitialData' || message.data=='initialData') && !alreadyInitialized){
	// 	alreadyInitialized=true
	// 	initialState=JSON.parse(JSON.stringify(elementaryComments))
	// 	sendResponse({'jsonData':initialState})
	// 	init()
	// }
})
//console.log(initListener,mainListener)